function semi_logl = semi_logl(data, par, cop_opt, dx, dz, kk, kne, knv)

y = data(:,1);
d = data(:,2);
x = data(:,3:2+dx);
z = data(:,(3+dx):(2+dx+dz));

alpha = par(1:dx) ;
gamma = par(dx+1:dx+dz) ;
beta = par(dx+dz+1:dx+dz+dx) ;
delta = par(dx+dz+dx+1) ;
rho = par(kk) ;
xie = par(kk+1:kk+kne) ;
conse = par(kk+kne+1) ;
xiv = par(kk+kne+2:kk+kne+1+knv) ;
consv = par(kk+kne+knv+2) ;

sieve_par_e = [xie; conse] ;
sieve_par_v = [xiv; consv] ;

% Choose bivariate distribution here
if cop_opt == 0
    copula = @(u1,u2,dep)copulacdf('Gaussian',[u1,u2],[1,dep;dep,1]);
    %copula = @(u1,u2,rho)normcop(u1,u2,rho);
elseif cop_opt == 2
    copula = @(u1,u2,dep)copulacdf('Frank',[u1,u2],dep);
elseif cop_opt == 3
    copula = @(u1,u2,dep)copulacdf('Clayton',[u1,u2],dep);
elseif cop_opt == 5
    copula = @(u1,u2,dep)copulacdf('Gumbel',[u1,u2],dep);
end



reduce_index = normcdf((x*alpha + z*gamma), 0, 1) ;
out0_index = normcdf((x*beta), 0, 1) ;
out1_index = normcdf((x*beta + d*delta), 0, 1) ;

s = dist(reduce_index, sieve_par_v, knv) ;
r0 = dist(out0_index, sieve_par_e, kne) ;
r1 = dist(out1_index, sieve_par_e, kne) ;

p11 = copula(r1, s, rho) ;
p10 = r0 - copula(r0,s,rho) ;
p01 = s - copula(r1, s, rho) ;
p00 = 1 - p11 - p10 - p01 ;

p11(p11<=0) = 1e-10 ;
p00(p00<=0) = 1e-10 ;
p10(p10<=0) = 1e-10 ;
p01(p01<=0) = 1e-10 ;

L11 = (y==1).*(d==1).*log(p11);
L10 = (y==1).*(d==0).*log(p10);
L01 = (y==0).*(d==1).*log(p01);
L00 = (y==0).*(d==0).*log(p00);


logL0 = L11 + L10 + L01 + L00;

%fprintf('IsNAN=%d ',sum(isnan(logL0)));
logL0_s = logL0(0==isnan(logL0));
logL0_s = logL0_s(0==isinf(logL0_s));
n_s = size(logL0_s,1);

semi_logl = - sum(logL0_s)/n_s; 
